
    <div class="container mt-4">
        <div class="row">
            <div class="col-12">
                <?php Flash::flash(); ?>
            </div>

            
            <div class="col-12 mt-4">
                <h3>Daftar Mahasiswa</h3>
            </div>
            
            <div class="col-12 mt-3">
                <button type="button" class="btn btn-primary" id="addMhs" data-bs-toggle="modal" data-bs-target="#formModal">
                    Add Mahasiswa
                </button>
            </div>
            
            <div class="col-12 mt-4 overflow-auto">
                <table id="example" class="table table-striped table-hover mt-2" style="width:100%">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Name</th>
                            <th>NRP</th>
                            <th>Email</th>
                            <th>Jurusan</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $i = 1; foreach($data["mahasiswa"] as $mahasiswa): ?>
                        <tr>
                            <td><?= $i; ?></td>
                            <td>
                                <a href="<?= BASE_URL; ?>mahasiswa/detail/<?= $mahasiswa["id"]; ?>" class="text-decoration-none"><?= $mahasiswa["nama"]; ?></a>
                            </td>
                            <td><?= $mahasiswa["nrp"]; ?></td>
                            <td><?= $mahasiswa["email"]; ?></td>
                            <td><?= $mahasiswa["jurusan"]; ?></td>
                            <td>
                                <a href="<?= BASE_URL; ?>mahasiswa/edit/<?= $mahasiswa["id"]; ?>" class="btn btn-success btn-sm ms-1 editMhs" data-id="<?= $mahasiswa["id"]; ?>" data-bs-toggle="modal" data-bs-target="#formModal">Edit</a>
                                <a href="<?= BASE_URL; ?>mahasiswa/delete/<?= $mahasiswa["id"]; ?>" onclick="return confirm('Ingin hapus?')"><button type="button" class="btn btn-danger btn-sm ms-1">Delete</button></a>
                            </td>
                        </tr>
                        <?php $i++; endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>

    <div class="modal fade" id="formModal" tabindex="-1" aria-labelledby="formModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="formModalLabel"></h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form action="<?= BASE_URL; ?>mahasiswa/tambah" method="POST" id="formMhs">
                    <input type="hidden" name="id" id="id">
                    <div class="mb-3">
                        <label for="nama" class="form-label">Nama Mahasiswa</label>
                        <input type="text" name="nama" class="form-control" id="nama">
                    </div>
                    <div class="mb-3">
                        <label for="nrp" class="form-label">NRP</label>
                        <input type="number" name="nrp" class="form-control" id="nrp">
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email address</label>
                        <input type="email" name="email" class="form-control" id="email">
                    </div>
                    <div class="mb-3">
                        <label for="jurusan" class="form-label">Jurusan</label>
                        <select class="form-select" aria-label="Default select example" id="jurusan" name="jurusan">
                            <option selected>-- Pilih Jurusan</option>
                            <option value="Teknik Informatika">Teknik Informatika</option>
                            <option value="Teknik Mesin">Teknik Mesin</option>
                            <option value="Teknik Industri">Teknik Industri</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary"></button>
                </div>
                </form>
            </div>
        </div>
    </div>